/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.client.features.loadingScreens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import me.juancarloscp52.bedrockify.client.features.loadingScreens.ExternalLoadingTips;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8020;

public class LoadingScreenWidget {
    private static LoadingScreenWidget instance = null;
    private static final int TIPS_NUM = 107;
    private final class_2960 WIDGET_TEXTURE = class_2960.method_60655((String)"bedrockify", (String)"textures/gui/bedrockify_widgets.png");
    private class_2561 tip;
    private static final List<Integer> EXCLUDED_TIPS = Lists.asList((Object)15, (Object[])new Integer[]{23, 28, 29, 32, 33, 34, 35, 62});
    private long lastTipUpdate = 0L;
    private final ExternalLoadingTips externalLoadingTips = ExternalLoadingTips.loadSettings();
    private final class_8020 logoDrawer;

    private LoadingScreenWidget() {
        this.externalLoadingTips.saveSettings();
        this.logoDrawer = new class_8020(false);
    }

    public static LoadingScreenWidget getInstance() {
        if (instance == null) {
            instance = new LoadingScreenWidget();
        }
        return instance;
    }

    private class_2561 getTip() {
        if (this.tip == null || System.currentTimeMillis() - this.lastTipUpdate > 6000L) {
            int random = new Random().nextInt(108) + 1;
            if ((random > 107 || this.externalLoadingTips.alwaysExternalTips) && this.externalLoadingTips.externalLoadingTips.length > 0) {
                random = new Random().nextInt(this.externalLoadingTips.externalLoadingTips.length);
                this.tip = class_2561.method_43470((String)this.externalLoadingTips.externalLoadingTips[random]);
            } else {
                if (EXCLUDED_TIPS.contains(random)) {
                    return this.getTip();
                }
                this.tip = class_2561.method_43471((String)("bedrockify.loadingTips." + random));
            }
            this.lastTipUpdate = System.currentTimeMillis();
        }
        return this.tip;
    }

    public void render(class_332 drawContext, int width, int height, class_2561 title, class_2561 message, int progress) {
        class_310 client = class_310.method_1551();
        this.logoDrawer.method_48210(drawContext, client.method_22683().method_4486(), 1.0f, height / 2 - 44);
        this.renderLoadingWidget(drawContext, width, height);
        class_327 textRenderer = class_310.method_1551().field_1772;
        drawContext.method_51439(textRenderer, title, width - textRenderer.method_27525((class_5348)title) / 2, height - 4 - 32, 0x4C4C4C, false);
        this.renderTextBody(drawContext, width, height, message, textRenderer);
        if (progress >= 0) {
            this.renderLoadingBar(drawContext, width, height, progress);
        }
    }

    private void renderLoadingWidget(class_332 drawContext, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        drawContext.method_25302(this.WIDGET_TEXTURE, x - 128, y - 44, 0, 0, 256, 89);
    }

    private void renderTextBody(class_332 drawContext, int x, int y, class_2561 message, class_327 textRenderer) {
        if (message == null) {
            message = this.getTip();
        }
        List text = textRenderer.method_1728((class_5348)message, 230);
        int maxLineWidth = this.getMaxLineWidth(textRenderer, text);
        for (int i = 0; i < 4 && i < text.size(); ++i) {
            drawContext.method_51430(textRenderer, (class_5481)text.get(i), x - maxLineWidth / 2, y - 15 + i * 9, 0xFFFFFF, false);
        }
    }

    private int getMaxLineWidth(class_327 textRenderer, List<class_5481> text) {
        int maxLineWidth = 0;
        for (int i = 0; i < 4 && i < text.size(); ++i) {
            int lineWidth = textRenderer.method_30880(text.get(i));
            if (lineWidth <= maxLineWidth) continue;
            maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }

    private void renderLoadingBar(class_332 drawContext, int x, int y, int progress) {
        int barProgress = (int)((float)class_3532.method_15340((int)progress, (int)0, (int)100) / 100.0f * 223.0f);
        drawContext.method_25302(this.WIDGET_TEXTURE, x - 111, y + 26, 0, 89, 222, 5);
        if (barProgress > 0) {
            drawContext.method_25302(this.WIDGET_TEXTURE, x - 111, y + 26, 0, 94, barProgress, 5);
        }
    }
}

